/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 80031 (8.0.31)
 Source Host           : localhost:3306
 Source Schema         : whatsgw

 Target Server Type    : MySQL
 Target Server Version : 80031 (8.0.31)
 File Encoding         : 65001

 Date: 26/11/2023 13:39:30
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for attempts
-- ----------------------------
DROP TABLE IF EXISTS `attempts`;
CREATE TABLE `attempts`  (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int UNSIGNED NULL DEFAULT NULL,
  `action` char(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `is_success` tinyint NULL DEFAULT NULL,
  `reason` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `ip_address` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of attempts
-- ----------------------------
INSERT INTO `attempts` VALUES (1, 2, 'Login', 1, 'Login Success', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36', '2023-11-21 20:25:40', 2, NULL, NULL, NULL, NULL);
INSERT INTO `attempts` VALUES (2, 2, 'Login', 0, 'Password not match', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36', '2023-11-21 20:25:54', 2, NULL, NULL, NULL, NULL);
INSERT INTO `attempts` VALUES (3, 2, 'Login', 1, 'Login Success', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36', '2023-11-21 20:25:57', 2, NULL, NULL, NULL, NULL);
INSERT INTO `attempts` VALUES (4, 1, 'Login', 0, 'Password not match', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36', '2023-11-21 20:26:14', 1, NULL, NULL, NULL, NULL);
INSERT INTO `attempts` VALUES (5, 1, 'Login', 1, 'Login Success', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36', '2023-11-21 20:27:26', 1, NULL, NULL, NULL, NULL);
INSERT INTO `attempts` VALUES (6, 1, 'Login', 1, 'Login Success', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36', '2023-11-24 20:59:57', 1, NULL, NULL, NULL, NULL);
INSERT INTO `attempts` VALUES (7, 1, 'Login', 1, 'Login Success', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36', '2023-11-25 21:37:40', 1, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for auto_replies
-- ----------------------------
DROP TABLE IF EXISTS `auto_replies`;
CREATE TABLE `auto_replies`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `message` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `reply` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `is_regex` enum('Yes','No') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'No',
  `device_id` int NULL DEFAULT NULL,
  `status` enum('Active','Inactive') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'Active',
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of auto_replies
-- ----------------------------
INSERT INTO `auto_replies` VALUES (1, '/halo', 'saya siapa?', 'No', 1, 'Active', '2023-11-26 11:33:33', 1, '2023-11-26 12:49:49', 1, NULL, NULL);
INSERT INTO `auto_replies` VALUES (2, '/ping', 'pong!', 'No', 1, 'Active', '2023-11-26 12:56:59', 1, '2023-11-26 13:01:59', 1, NULL, NULL);
INSERT INTO `auto_replies` VALUES (3, '/pong', 'ping!', 'No', 1, 'Active', '2023-11-26 12:58:30', 1, NULL, NULL, NULL, NULL);
INSERT INTO `auto_replies` VALUES (4, 'apakah(.*)tersedia', 'barang tidak tersedia', 'Yes', 1, 'Active', '2023-11-26 13:01:10', 1, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for banks
-- ----------------------------
DROP TABLE IF EXISTS `banks`;
CREATE TABLE `banks`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `picture` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `name` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `account_name` varchar(75) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `account_address` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `mode` enum('Otomatis','Manual') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `status` enum('Show','Hide') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'Show',
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of banks
-- ----------------------------
INSERT INTO `banks` VALUES (1, NULL, 'Deposit', '-', '-', 'Otomatis', 'Hide', '2023-05-09 09:22:34', 0, '2023-05-15 20:42:27', NULL, NULL, NULL);
INSERT INTO `banks` VALUES (2, NULL, 'Dana', 'Devian Reviawan', '089618659889', 'Manual', 'Show', '2023-05-09 09:22:53', 0, '2023-05-15 20:42:18', NULL, NULL, NULL);
INSERT INTO `banks` VALUES (3, NULL, 'Ovo', 'Devian Reviawan', '089618659889', 'Manual', 'Show', '2023-11-08 09:41:16', 0, '2023-11-15 22:32:21', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for bills
-- ----------------------------
DROP TABLE IF EXISTS `bills`;
CREATE TABLE `bills`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `reference_table` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `reference_id` int NULL DEFAULT NULL,
  `user_id` int NULL DEFAULT NULL,
  `invoice` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `amount` int NULL DEFAULT NULL,
  `amount_request` int NULL DEFAULT NULL,
  `amount_additional` int NULL DEFAULT NULL,
  `params` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `type` enum('Order','Renew') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'Order',
  `status` enum('Pending','Paid','Fail') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'Pending',
  `bank_id` int NULL DEFAULT NULL,
  `bank_account` varchar(75) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `bank_address` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of bills
-- ----------------------------
INSERT INTO `bills` VALUES (1, 'devices', 1, 1, 'x998asolp8df1eq', 'Anda melakukan pemesanan paket whatsapp Regular selama 1 bulan.', 25374, 25000, 374, NULL, 'Order', 'Paid', 2, 'Devian Reviawan', '089618659889', '2023-11-21 20:27:51', 1, '2023-11-21 20:28:03', 1, NULL, NULL);
INSERT INTO `bills` VALUES (2, 'devices', 1, 1, 'x9986kwlpf3wn2t', 'Anda melakukan perpanjangan masa aktif whatsapp x998asolp8df1eq selama 1 bulan.', 25183, 25000, 183, '{\"device\":{\"expired_at\":\"2024-01-21 23:59:59\",\"status\":\"active\"}}', 'Renew', 'Pending', 2, 'Devian Reviawan', '089618659889', '2023-11-26 13:35:59', 1, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for devices
-- ----------------------------
DROP TABLE IF EXISTS `devices`;
CREATE TABLE `devices`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `package_id` int NULL DEFAULT NULL,
  `user_id` int NULL DEFAULT NULL,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `session` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `status` enum('active','inactive','unpaid','expired') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'active',
  `status_sub` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `auto_payment` int NULL DEFAULT 0,
  `webhook_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `expired_at` datetime NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of devices
-- ----------------------------
INSERT INTO `devices` VALUES (1, 2, 1, 'Redmi Note 10s', 'x998asolp8df1eq', 'active', 'QR Code', 0, NULL, '2023-12-21 23:59:59', '2023-11-21 20:27:51', 1, '2023-11-26 13:38:14', 1, NULL, NULL);
INSERT INTO `devices` VALUES (2, 1, 1, 'x998180lpf3jhv9', 'x998180lpf3jhv9', 'inactive', 'Disconnected', 0, NULL, '2023-11-29 23:59:59', '2023-11-26 13:25:46', 1, '2023-11-26 13:35:30', NULL, NULL, NULL);
INSERT INTO `devices` VALUES (3, 1, 1, 'Trial 1', 'x9986wclpf3kp3c', 'active', 'QR Code', 0, NULL, '2023-11-29 23:59:59', '2023-11-26 13:26:42', 1, '2023-11-26 13:38:33', 1, NULL, NULL);

-- ----------------------------
-- Table structure for messages
-- ----------------------------
DROP TABLE IF EXISTS `messages`;
CREATE TABLE `messages`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` enum('In','Out') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `device_id` int NULL DEFAULT NULL,
  `phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `media_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `media_type` enum('text','image','audio','document','video') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'text',
  `send_at` datetime NULL DEFAULT NULL,
  `status` enum('pending','sent','fail') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'pending',
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `sended_at` datetime NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 22 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of messages
-- ----------------------------
INSERT INTO `messages` VALUES (1, 'In', 1, '6285655209270', 'test', '-', 'text', '2023-11-24 21:23:33', 'sent', NULL, '2023-11-24 21:23:33', '2023-11-24 21:23:33', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (2, 'In', 1, '6285655209270', 'hehe', '-', 'text', '2023-11-24 21:27:37', 'sent', NULL, '2023-11-24 21:27:37', '2023-11-24 21:27:37', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (3, 'In', 1, '6285655209270', 'qqq', '-', 'text', '2023-11-24 21:28:15', 'sent', NULL, '2023-11-24 21:28:15', '2023-11-24 21:28:15', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (4, 'In', 1, '6285655209270', 'www', '-', 'text', '2023-11-24 21:28:44', 'sent', NULL, '2023-11-24 21:28:44', '2023-11-24 21:28:44', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (5, 'In', 1, '6285655209270', 'hwhwhw', '-', 'text', '2023-11-24 21:29:56', 'sent', NULL, '2023-11-24 21:29:56', '2023-11-24 21:29:56', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (6, 'In', 1, '6285655209270', 'hwhwhwhw', '-', 'text', '2023-11-24 21:30:12', 'sent', NULL, '2023-11-24 21:30:12', '2023-11-24 21:30:12', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (7, 'In', 1, '6285655209270', 'zxzxzx', '-', 'text', '2023-11-24 21:49:47', 'sent', NULL, '2023-11-24 21:49:47', '2023-11-24 21:49:47', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (8, 'In', 1, '6285655209270', 'hehe', '-', 'text', '2023-11-25 21:57:49', 'sent', NULL, '2023-11-25 21:57:49', '2023-11-25 21:57:49', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (9, 'In', 1, '6285655209270', '/halo', '-', 'text', '2023-11-26 12:50:36', 'sent', NULL, '2023-11-26 12:50:36', '2023-11-26 12:50:36', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (10, 'In', 1, '6285655209270', '/halo', '-', 'text', '2023-11-26 12:53:13', 'sent', NULL, '2023-11-26 12:53:13', '2023-11-26 12:53:13', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (11, 'In', 1, '6285655209270', '/halo', '-', 'text', '2023-11-26 12:55:18', 'sent', NULL, '2023-11-26 12:55:18', '2023-11-26 12:55:18', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (12, 'In', 1, '6285655209270', '/halo', '-', 'text', '2023-11-26 12:56:06', 'sent', NULL, '2023-11-26 12:56:06', '2023-11-26 12:56:06', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (13, 'In', 1, '6285655209270', '/ping', '-', 'text', '2023-11-26 12:57:06', 'sent', NULL, '2023-11-26 12:57:06', '2023-11-26 12:57:06', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (14, 'In', 1, '6285655209270', '/ping', '-', 'text', '2023-11-26 12:58:08', 'sent', NULL, '2023-11-26 12:58:08', '2023-11-26 12:58:08', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (15, 'In', 1, '6285655209270', '/pong', '-', 'text', '2023-11-26 12:58:38', 'sent', NULL, '2023-11-26 12:58:38', '2023-11-26 12:58:38', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (16, 'In', 1, '6285655209270', '!ping', '-', 'text', '2023-11-26 12:58:49', 'sent', NULL, '2023-11-26 12:58:49', '2023-11-26 12:58:49', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (17, 'In', 1, '6285655209270', '!ping', '-', 'text', '2023-11-26 12:59:03', 'sent', NULL, '2023-11-26 12:59:03', '2023-11-26 12:59:03', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (18, 'In', 1, '6285655209270', 'apakah barang tersedia?', '-', 'text', '2023-11-26 13:01:21', 'sent', NULL, '2023-11-26 13:01:21', '2023-11-26 13:01:21', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (19, 'In', 1, '6285655209270', '!ping', '-', 'text', '2023-11-26 13:01:39', 'sent', NULL, '2023-11-26 13:01:39', '2023-11-26 13:01:39', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (20, 'In', 1, '6285655209270', '!ping', '-', 'text', '2023-11-26 13:01:50', 'sent', NULL, '2023-11-26 13:01:50', '2023-11-26 13:01:50', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `messages` VALUES (21, 'In', 1, '6285655209270', '/ping', '-', 'text', '2023-11-26 13:02:04', 'sent', NULL, '2023-11-26 13:02:04', '2023-11-26 13:02:04', NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for notifications
-- ----------------------------
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NULL DEFAULT NULL,
  `type` enum('General') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `message` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `is_show` int NULL DEFAULT 0,
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 31 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of notifications
-- ----------------------------
INSERT INTO `notifications` VALUES (1, 1, 'General', 'Hehe', 1, '2023-11-15 15:46:24', 1, '2023-11-15 20:42:56', NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (2, 1, 'General', '[2ry317fcloztbzb2] Anda melakukan pemesanan paket whatsapp Regular selama 1 bulan.', 0, '2023-11-15 20:43:26', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (3, 1, 'General', '[2ry317fcloztbzb2] Pembayaran pembelian paket whatsapp telah berhasil diterima admin!', 0, '2023-11-15 20:50:28', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (4, 1, 'General', '[2ry314f4lp2qrgcu] Anda melakukan pemesanan paket whatsapp Regular selama 3 bulan.', 0, '2023-11-17 21:54:48', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (5, 1, 'General', '[2ry315xwlp2qw3ol] Anda melakukan pemesanan paket whatsapp Regular selama 1 bulan.', 0, '2023-11-17 21:58:25', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (6, 1, 'General', '[2ry318f8lp2r3l3y] Anda melakukan pemesanan paket whatsapp Regular selama 1 bulan.', 0, '2023-11-17 22:04:14', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (7, 1, 'General', '[2ry31580lp2r4isw] Anda melakukan pemesanan paket whatsapp Regular selama 1 bulan.', 0, '2023-11-17 22:04:57', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (8, 1, 'General', '[2ry317z4lp2r8fdb] Anda melakukan pemesanan paket whatsapp Regular selama 3 bulan.', 0, '2023-11-17 22:08:00', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (9, 1, 'General', '[2ry317z4lp2r8fdb] Pembayaran pembelian paket whatsapp sedang ditinjau admin!', 0, '2023-11-17 22:09:11', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (10, 1, 'General', '[2ry317z4lp2r8fdb] Pembayaran pembelian paket whatsapp sedang ditinjau admin!', 0, '2023-11-17 22:10:46', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (11, 1, 'General', '[2ry317z4lp2r8fdb] Pembayaran pembelian paket whatsapp sedang ditinjau admin!', 0, '2023-11-17 22:11:38', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (12, 1, 'General', '[2ry317z4lp2r8fdb] Pembayaran pembelian paket whatsapp sedang ditinjau admin!', 0, '2023-11-17 22:14:13', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (13, 1, 'General', '[2ry317z4lp2r8fdb] Pembayaran pembelian paket whatsapp tidak berhasil, silahkan hubungi admin!', 0, '2023-11-17 22:17:27', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (14, 1, 'General', '[2ry317z4lp2r8fdb] Pembayaran pembelian paket whatsapp telah berhasil diterima admin!', 0, '2023-11-17 22:17:46', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (15, 1, 'General', '[2ry317f0lp2rlsg0] Anda melakukan perpanjangan masa aktif whatsapp 2ry317z4lp2r8fdb selama 1 bulan.', 0, '2023-11-17 22:18:23', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (16, 1, 'General', '[2ry3193olp2rnldf] Anda melakukan perpanjangan masa aktif whatsapp 2ry317z4lp2r8fdb selama 1 bulan.', 0, '2023-11-17 22:19:47', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (17, 1, 'General', '[2ry3193olp2rnldf] Pembayaran perpanjangan paket whatsapp sedang ditinjau admin!', 0, '2023-11-17 22:20:18', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (18, 1, 'General', '[2ry3193olp2rnldf] Pembayaran perpanjangan paket whatsapp tidak berhasil, silahkan hubungi admin!', 0, '2023-11-17 22:20:40', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (19, 1, 'General', '[2ry3193olp2rnldf] Pembayaran perpanjangan paket whatsapp telah berhasil diterima admin!', 0, '2023-11-17 22:21:04', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (20, 1, 'General', '[2ry3193olp2rpzmm] Anda melakukan pemesanan paket whatsapp Profesional selama 6 bulan.', 0, '2023-11-17 22:21:39', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (21, 1, 'General', '[2ry3193olp2rpzmm] Pembayaran pembelian paket whatsapp sedang ditinjau admin!', 0, '2023-11-17 22:22:16', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (22, 1, 'General', '[2ry3193olp2rpzmm] Pembayaran pembelian paket whatsapp tidak berhasil, silahkan hubungi admin!', 0, '2023-11-17 22:22:37', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (23, 1, 'General', '[2ry3193olp2rpzmm] Pembayaran pembelian paket whatsapp telah berhasil diterima admin!', 0, '2023-11-17 22:22:52', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (24, 1, 'General', '[2ry315c0lp45g2k3] Anda melakukan perpanjangan masa aktif whatsapp 2ry313sgloyc1tn6 selama 1 bulan.', 0, '2023-11-18 21:33:37', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (25, 1, 'General', '[2ry315c0lp45g2k3] Pembayaran perpanjangan paket whatsapp telah berhasil diterima admin!', 0, '2023-11-18 21:34:03', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (26, 1, 'General', '[x998asolp8df1eq] Anda melakukan pemesanan paket whatsapp Regular selama 1 bulan.', 0, '2023-11-21 20:27:51', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (27, 1, 'General', '[x998asolp8df1eq] Pembayaran pembelian paket whatsapp telah berhasil diterima admin!', 0, '2023-11-21 20:28:03', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (28, 1, 'General', 'Aktifasi paket trial Berhasil!', 0, '2023-11-26 13:25:46', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (29, 1, 'General', 'Aktifasi paket trial Berhasil!', 0, '2023-11-26 13:26:42', 1, NULL, NULL, NULL, NULL);
INSERT INTO `notifications` VALUES (30, 1, 'General', '[x9986kwlpf3wn2t] Anda melakukan perpanjangan masa aktif whatsapp x998asolp8df1eq selama 1 bulan.', 0, '2023-11-26 13:35:59', 1, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for packages
-- ----------------------------
DROP TABLE IF EXISTS `packages`;
CREATE TABLE `packages`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `slug` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `price` int NULL DEFAULT NULL,
  `price_label` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `name` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `features` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `status` enum('show','hide','coming soon','in repair') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of packages
-- ----------------------------
INSERT INTO `packages` VALUES (1, 'trial', 0, '0K', 'Trial', '[\"text\",\"image\",\"audio\",\"video\", \"document\"]', '[\"Trial 3 Hari\", \"Unlimited Message\", \"Send Text Message\", \"Send Image\", \"Send Audio\", \"Send Video\", \"Send Document\",  \"Api Access\", \"Scheduler\", \"Auto Reply\", \"Webhook\"]', 'show', '2023-04-17 10:23:44', 0, NULL, NULL, NULL, NULL);
INSERT INTO `packages` VALUES (2, 'regular', 25000, '25K', 'Regular', '[\"text\"]', '[\"Unlimited Message\", \"Send Text Message\", \"Api Access\", \"Scheduler\", \"Auto Reply\", \"Webhook\"]', 'show', '2023-04-17 10:23:44', 0, NULL, NULL, NULL, NULL);
INSERT INTO `packages` VALUES (3, 'pro', 75000, '75K', 'Profesional', '[\"text\",\"image\"]', '[\"Unlimited Message\", \"Send Text Message\", \"Send Image\", \"Api Access\", \"Scheduler\", \"Auto Reply\", \"Webhook\"]', 'show', '2023-04-19 11:34:07', 0, NULL, NULL, NULL, NULL);
INSERT INTO `packages` VALUES (4, 'bussiness', 100000, '150K', 'Bussiness', '[\"text\",\"image\",\"audio\",\"video\", \"document\"]', '[\"Unlimited Message\", \"Send Text Message\", \"Send Image\", \"Send Audio\", \"Send Video\", \"Send Document\",  \"Api Access\", \"Scheduler\", \"Auto Reply\", \"Webhook\"]', 'show', '2023-04-19 11:34:31', 0, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for tokens
-- ----------------------------
DROP TABLE IF EXISTS `tokens`;
CREATE TABLE `tokens`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NULL DEFAULT NULL,
  `type` enum('Lost Password') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `expired_at` datetime NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of tokens
-- ----------------------------

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `email` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `group` enum('admin','member','journalist') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `phone` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `photo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `password` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `api_key` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `status` enum('pending','active','inactive','suspend') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'active',
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES (1, 'Devian Reviawans', 'admin', 'sakuratadevapp@gmail.com', 'admin', '089618659889', '2ry31498lo2mmole.jpeg', 'sha1$4aebe597$1$e9bd5202c49beeb15848893a76f3bafbcc2d916a', '123654789', 'active', '2023-03-30 20:10:50', 0, '2023-11-17 21:11:57', 1, NULL, NULL);
INSERT INTO `users` VALUES (2, 'Saya sendiri', 'user', 'sakuratacrackid@gmail.com', 'member', '089618659889', 'user.png', 'sha1$4aebe597$1$e9bd5202c49beeb15848893a76f3bafbcc2d916a', 'x998asolp8dc12f', 'active', '2023-11-21 20:25:30', NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for wallets
-- ----------------------------
DROP TABLE IF EXISTS `wallets`;
CREATE TABLE `wallets`  (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `bill_id` int NULL DEFAULT NULL,
  `type` enum('In','Out') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT 'In',
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `user_id` int NULL DEFAULT NULL,
  `amount` int NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of wallets
-- ----------------------------

-- ----------------------------
-- Table structure for webhooks
-- ----------------------------
DROP TABLE IF EXISTS `webhooks`;
CREATE TABLE `webhooks`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `device_id` int NULL DEFAULT NULL,
  `url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `event` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `status` enum('Pending','Success','Fail') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'Pending',
  `response` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `created_by` int NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `updated_by` int NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `deleted_by` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 12 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of webhooks
-- ----------------------------
INSERT INTO `webhooks` VALUES (1, 1, 'https://undanganku.my.id/webhook', 'connection', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"connection\",\"status\":\"connecting\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-25 21:52:11', NULL, '2023-11-25 21:52:14', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (2, 1, 'https://undanganku.my.id/webhook', 'connection', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"connection\",\"status\":\"connecting\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-25 21:52:20', NULL, '2023-11-25 21:52:22', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (3, 1, 'https://undanganku.my.id/webhook', 'connection', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"connection\",\"status\":\"disconnected\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-25 21:57:11', NULL, '2023-11-25 21:57:12', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (4, 1, 'https://undanganku.my.id/webhook', 'connection', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"connection\",\"status\":\"connecting\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-25 21:57:11', NULL, '2023-11-25 21:57:13', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (5, 1, 'https://undanganku.my.id/webhook', 'connection', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"connection\",\"status\":\"connected\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-25 21:57:12', NULL, '2023-11-25 21:57:13', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (6, 1, 'https://undanganku.my.id/webhook', 'message', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"message\",\"phone\":\"6285655209270\",\"message\":\"hehe\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-25 21:57:49', NULL, '2023-11-25 21:57:50', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (7, 1, 'https://undanganku.my.id/webhook', 'connection', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"connection\",\"status\":\"connecting\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-26 09:42:00', NULL, '2023-11-26 09:42:01', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (8, 1, 'https://undanganku.my.id/webhook', 'connection', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"connection\",\"status\":\"connected\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-26 09:42:01', NULL, '2023-11-26 09:42:02', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (9, 1, 'https://undanganku.my.id/webhook', 'connection', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"connection\",\"status\":\"disconnected\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-26 09:42:21', NULL, '2023-11-26 09:42:22', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (10, 1, 'https://undanganku.my.id/webhook', 'connection', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"connection\",\"status\":\"connecting\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-26 09:42:22', NULL, '2023-11-26 09:42:22', NULL, NULL, NULL);
INSERT INTO `webhooks` VALUES (11, 1, 'https://undanganku.my.id/webhook', 'qr', '{\"session_id\":\"x998asolp8df1eq\",\"event\":\"qr\",\"qrcode\":\"2@nKFSij+gbr3820yqAcGW2ixT/Wm92KpiD6j4Py0tcWYYr1GUSYmbQOkvipBjZ39BqVpcbke/VamyaQ==,Dge5eWEHS2U43JjPRDTTWJ7Tw/iWQB3rgdZC5hlYDEE=,DUJbH1zS9ulCyR64qMafAzfrBwsC+QuxcFcNBm9F7CI=,KV2cKf5vGn+mtFIHcg8/43yK4y869Qn8c1KMv30x7Jk=\"}', 'Fail', 'AxiosError: Request failed with status code 404', '2023-11-26 09:42:23', NULL, '2023-11-26 09:42:24', NULL, NULL, NULL);

-- ----------------------------
-- Procedure structure for clean_up
-- ----------------------------
DROP PROCEDURE IF EXISTS `clean_up`;
delimiter ;;
CREATE PROCEDURE `clean_up`()
BEGIN
	TRUNCATE TABLE attempts;
	TRUNCATE TABLE bills;
	TRUNCATE TABLE devices;
	TRUNCATE TABLE messages;
	TRUNCATE TABLE tokens;
	TRUNCATE TABLE wallets;
	TRUNCATE TABLE webhooks;
	DELETE FROM users where id > 1;
	ALTER TABLE users AUTO_INCREMENT = 1;
END
;;
delimiter ;

SET FOREIGN_KEY_CHECKS = 1;
