exports.datatables = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('notifications');
			datatable.rest(req, res);
			datatable.search('created_at', 'message', 'is_show', 'id');
			datatable.params([
				['select', 'created_at', 'message', 'is_show', 'id'],
			]);
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.changestatus = ($) => {

	const __constructor = async function(req, res) {
		try {
			if(req.validate.isEmpty()) {
				const id = $.helper('text').sanitize_int(req.params.id);
				const status = $.helper('text').sanitize_int(req.body.status);
				await $.model('notifications').batchUpdate([
					['where', 'id', '=', id],
					['where', 'user_id', '=', req.auth.user('id')]
				], {is_show: status})
				return res.json({
						message: "Perubahan disimpan!"
					});
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}