const base_services = require("./base_services.js");

class attempts extends base_services {

	constructor() {
		super();
	}

	async login_success(req, user_id, reason="Login Success") {
		await this.model('attempts').insert({
			user_id: user_id,
			action: "Login",
			is_success: "1",
			reason: reason,
			ip_address: req.ip,
			user_agent: req.headers['user-agent'],
			created_by: user_id,
		});
	}

	async login_fail(req, user_id, reason) {
		await this.model('attempts').insert({
			user_id: user_id,
			action: "Login",
			is_success: "0",
			reason: reason,
			ip_address: req.ip,
			user_agent: req.headers['user-agent'],
			created_by: user_id,
		});
	}

	async forgot(req, user_id) {
		await this.model('attempts').insert({
			user_id: user_id,
			action: "Forgot",
			is_success: "1",
			reason: "Lost Password",
			ip_address: req.ip,
			user_agent: req.headers['user-agent'],
			created_by: user_id,
		});
	}

	async register(req, user_id) {
		await this.model('attempts').insert({
			user_id: user_id,
			action: "Register",
			is_success: "1",
			reason: "New Account",
			ip_address: req.ip,
			user_agent: req.headers['user-agent'],
			created_by: user_id,
		});
	}

}

module.exports = attempts;