const base_services = require("./base_services.js");
const fs = require("fs").promises;
const path = require("path");
const hb = require('handlebars');

class mail extends base_services {

	constructor() {
		super();
	}

	async forgot(params) {
		try {
			const mailConfig = this.config('mail');
			const config = mailConfig.config;
			const mail = mailConfig.mail;

			const loc = path.join(__dirname, '..', 'views/mail/forgot.html');
			let html = await fs.readFile(loc, 'utf-8').catch(err => {
				console.log(err);
			});

			if(html) {
				const template = hb.compile(html);

				html = template({
					app_name: this.config('app').app_name,
					name: params.name,
					username: params.username,
					app_mail: this.config('app').app_mail,
					app_phone: this.config('app').app_phone,
					url: params.url
				});

				const toMail = this.config('app').boot.toLowerCase() == 'development' ? this.config('app').app_mail : params.email;
				const mailOptions = {
				  from: this.config('app', 'app_mail_from'),
				  to: toMail,
				  subject: `Lupa Kata Sandi | ${this.config('app').app_name}`,
				  html: html
				};

				mail.sendMail(mailOptions, function(error, info){
				  if (error) {
				    console.log(error);
				  } else {
				  	if(this.config('app', 'boot').toLowerCase() == 'development') {
				    	console.log('Email sent: ' + info.response);
				  	}
				  }
				});
			} else {
				throw 'empty html';
			}

		} catch(err) {
			console.log(err);
		}
	}

	async welcome(params) {
		try {
			const mailConfig = this.config('mail');
			const config = mailConfig.config;
			const mail = mailConfig.mail;

			const loc = path.join(__dirname, '..', 'views/mail/welcome.html');
			let html = await fs.readFile(loc, 'utf-8').catch(err => {
				console.log(err);
			});

			if(html) {
				const template = hb.compile(html);
				html = template({
					app_name: this.config('app').app_name,
					name: params.name,
					username: params.username,
					email: params.email,
					password: params.password,
					app_mail: this.config('app').app_mail,
					app_phone: this.config('app').app_phone,
				});

				const toMail = this.config('app').boot.toLowerCase() == 'development' ? this.config('app').app_mail : params.email;
				const mailOptions = {
				  from: this.config('app', 'app_mail_from'),
				  to: toMail,
				  subject: `Selamat datang di ${this.config('app').app_name}`,
				  html: html
				};

				mail.sendMail(mailOptions, function(error, info){
				  if (error) {
				    console.log(error);
				  } else {
				  	if(this.config('app', 'boot').toLowerCase() == 'development') {
				    	console.log('Email sent: ' + info.response);
				  	}
				  }
				});
			}
		} catch (err) {
			console.log(err);
		}
	}

	async bill_create(params) {
		try {
			const mailConfig = this.config('mail');
			const config = mailConfig.config;
			const mail = mailConfig.mail;

			const loc = path.join(__dirname, '..', 'views/mail/bill_create.html');
			let html = await fs.readFile(loc, 'utf-8').catch(err => {
				console.log(err);
			});

			if(html) {
				const template = hb.compile(html);
				html = template({
					app_name: this.config('app').app_name,
					app_mail: this.config('app').app_mail,
					app_phone: this.config('app').app_phone,
					name: params.name,
					username: params.username,
					description: params.description,
					invoice: params.invoice,
					bank_name: params.bank_name,
					rekening_nama: params.rekening_nama,
					rekening_nomor: params.rekening_nomor,
					created_at: params.created_at,
					amount_request: params.amount_request,
					amount_additional: params.amount_additional,
					amount: params.amount,
					status: params.status,
				});

				const toMail = this.config('app').boot.toLowerCase() == 'development' ? this.config('app').app_mail : params.email;
				const mailOptions = {
				  from: this.config('app', 'app_mail_from'),
				  to: toMail,
				  subject: `#${params.invoice} Tagihan Dibuat ${this.config('app').app_name}`,
				  html: html
				};

				mail.sendMail(mailOptions, function(error, info){
				  if (error) {
				    console.log(error);
				  } else {
				  	if(this.config('app', 'boot').toLowerCase() == 'development') {
				    	console.log('Email sent: ' + info.response);
				  	}
				  }
				});
			}
		} catch (err) {
			console.log(err);
		}
	}

	async bill_pending(params) {
		try {
			const mailConfig = this.config('mail');
			const config = mailConfig.config;
			const mail = mailConfig.mail;

			const loc = path.join(__dirname, '..', 'views/mail/bill_pending.html');
			let html = await fs.readFile(loc, 'utf-8').catch(err => {
				console.log(err);
			});

			if(html) {
				const template = hb.compile(html);
				html = template({
					app_name: this.config('app').app_name,
					app_mail: this.config('app').app_mail,
					app_phone: this.config('app').app_phone,
					name: params.name,
					username: params.username,
					description: params.description,
					invoice: params.invoice,
					bank_name: params.bank_name,
					rekening_nama: params.rekening_nama,
					rekening_nomor: params.rekening_nomor,
					created_at: params.created_at,
					amount_request: params.amount_request,
					amount_additional: params.amount_additional,
					amount: params.amount,
					status: params.status,
				});

				const toMail = this.config('app').boot.toLowerCase() == 'development' ? this.config('app').app_mail : params.email;
				const mailOptions = {
				  from: this.config('app', 'app_mail_from'),
				  to: toMail,
				  subject: `#${params.invoice} Tagihan Ditinjau ${this.config('app').app_name}`,
				  html: html
				};

				mail.sendMail(mailOptions, function(error, info){
				  if (error) {
				    console.log(error);
				  } else {
				  	if(this.config('app', 'boot').toLowerCase() == 'development') {
				    	console.log('Email sent: ' + info.response);
				  	}
				  }
				});
			}
		} catch (err) {
			console.log(err);
		}
	}

	async bill_success(params) {
		try {
			const mailConfig = this.config('mail');
			const config = mailConfig.config;
			const mail = mailConfig.mail;

			const loc = path.join(__dirname, '..', 'views/mail/bill_success.html');
			let html = await fs.readFile(loc, 'utf-8').catch(err => {
				console.log(err);
			});

			if(html) {
				const template = hb.compile(html);
				html = template({
					app_name: this.config('app').app_name,
					app_mail: this.config('app').app_mail,
					app_phone: this.config('app').app_phone,
					name: params.name,
					username: params.username,
					description: params.description,
					invoice: params.invoice,
					bank_name: params.bank_name,
					rekening_nama: params.rekening_nama,
					rekening_nomor: params.rekening_nomor,
					created_at: params.created_at,
					amount_request: params.amount_request,
					amount_additional: params.amount_additional,
					amount: params.amount,
					status: params.status,
				});

				const toMail = this.config('app').boot.toLowerCase() == 'development' ? this.config('app').app_mail : params.email;
				const mailOptions = {
				  from: this.config('app', 'app_mail_from'),
				  to: toMail,
				  subject: `#${params.invoice} Tagihan Diterima ${this.config('app').app_name}`,
				  html: html
				};

				mail.sendMail(mailOptions, function(error, info){
				  if (error) {
				    console.log(error);
				  } else {
				  	if(this.config('app', 'boot').toLowerCase() == 'development') {
				    	console.log('Email sent: ' + info.response);
				  	}
				  }
				});
			}
		} catch (err) {
			console.log(err);
		}
	}

	async bill_fail(params) {
		try {
			const mailConfig = this.config('mail');
			const config = mailConfig.config;
			const mail = mailConfig.mail;

			const loc = path.join(__dirname, '..', 'views/mail/bill_fail.html');
			let html = await fs.readFile(loc, 'utf-8').catch(err => {
				console.log(err);
			});

			if(html) {
				const template = hb.compile(html);
				html = template({
					app_name: this.config('app').app_name,
					app_mail: this.config('app').app_mail,
					app_phone: this.config('app').app_phone,
					name: params.name,
					username: params.username,
					description: params.description,
					invoice: params.invoice,
					bank_name: params.bank_name,
					rekening_nama: params.rekening_nama,
					rekening_nomor: params.rekening_nomor,
					created_at: params.created_at,
					amount_request: params.amount_request,
					amount_additional: params.amount_additional,
					amount: params.amount,
					status: params.status,
				});

				const toMail = this.config('app').boot.toLowerCase() == 'development' ? this.config('app').app_mail : params.email;
				const mailOptions = {
				  from: this.config('app', 'app_mail_from'),
				  to: toMail,
				  subject: `#${params.invoice} Tagihan Ditolak ${this.config('app').app_name}`,
				  html: html
				};

				mail.sendMail(mailOptions, function(error, info){
				  if (error) {
				    console.log(error);
				  } else {
				  	if(this.config('app', 'boot').toLowerCase() == 'development') {
				    	console.log('Email sent: ' + info.response);
				  	}
				  }
				});
			}
		} catch (err) {
			console.log(err);
		}
	}

}

module.exports = mail;